/*
 * Decompiled with CFR 0.152.
 */
package com.alignedcookie88.heartbound_smp.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextDecoration;

public class TextUtil {
    private static final Map<Character, Integer> CHAR_WIDTHS = Map.ofEntries(Map.entry(Character.valueOf(' '), 3), Map.entry(Character.valueOf('!'), 1), Map.entry(Character.valueOf('\"'), 3), Map.entry(Character.valueOf('#'), 5), Map.entry(Character.valueOf('$'), 5), Map.entry(Character.valueOf('%'), 5), Map.entry(Character.valueOf('&'), 5), Map.entry(Character.valueOf('\''), 1), Map.entry(Character.valueOf('('), 3), Map.entry(Character.valueOf(')'), 3), Map.entry(Character.valueOf('*'), 3), Map.entry(Character.valueOf('+'), 5), Map.entry(Character.valueOf(','), 1), Map.entry(Character.valueOf('-'), 5), Map.entry(Character.valueOf('.'), 1), Map.entry(Character.valueOf('/'), 5), Map.entry(Character.valueOf('0'), 5), Map.entry(Character.valueOf('1'), 5), Map.entry(Character.valueOf('2'), 5), Map.entry(Character.valueOf('3'), 5), Map.entry(Character.valueOf('4'), 5), Map.entry(Character.valueOf('5'), 5), Map.entry(Character.valueOf('6'), 5), Map.entry(Character.valueOf('7'), 5), Map.entry(Character.valueOf('8'), 5), Map.entry(Character.valueOf('9'), 5), Map.entry(Character.valueOf(':'), 1), Map.entry(Character.valueOf(';'), 1), Map.entry(Character.valueOf('<'), 4), Map.entry(Character.valueOf('='), 5), Map.entry(Character.valueOf('>'), 4), Map.entry(Character.valueOf('?'), 5), Map.entry(Character.valueOf('@'), 6), Map.entry(Character.valueOf('A'), 5), Map.entry(Character.valueOf('B'), 5), Map.entry(Character.valueOf('C'), 5), Map.entry(Character.valueOf('D'), 5), Map.entry(Character.valueOf('E'), 5), Map.entry(Character.valueOf('F'), 5), Map.entry(Character.valueOf('G'), 5), Map.entry(Character.valueOf('H'), 5), Map.entry(Character.valueOf('I'), 3), Map.entry(Character.valueOf('J'), 5), Map.entry(Character.valueOf('K'), 5), Map.entry(Character.valueOf('L'), 5), Map.entry(Character.valueOf('M'), 5), Map.entry(Character.valueOf('N'), 5), Map.entry(Character.valueOf('O'), 5), Map.entry(Character.valueOf('P'), 5), Map.entry(Character.valueOf('Q'), 5), Map.entry(Character.valueOf('R'), 5), Map.entry(Character.valueOf('S'), 5), Map.entry(Character.valueOf('T'), 5), Map.entry(Character.valueOf('U'), 5), Map.entry(Character.valueOf('V'), 5), Map.entry(Character.valueOf('W'), 5), Map.entry(Character.valueOf('X'), 5), Map.entry(Character.valueOf('Y'), 5), Map.entry(Character.valueOf('Z'), 5), Map.entry(Character.valueOf('['), 3), Map.entry(Character.valueOf('\\'), 5), Map.entry(Character.valueOf(']'), 3), Map.entry(Character.valueOf('^'), 5), Map.entry(Character.valueOf('_'), 5), Map.entry(Character.valueOf('`'), 2), Map.entry(Character.valueOf('a'), 5), Map.entry(Character.valueOf('b'), 5), Map.entry(Character.valueOf('c'), 5), Map.entry(Character.valueOf('d'), 5), Map.entry(Character.valueOf('e'), 5), Map.entry(Character.valueOf('f'), 4), Map.entry(Character.valueOf('g'), 5), Map.entry(Character.valueOf('h'), 5), Map.entry(Character.valueOf('i'), 1), Map.entry(Character.valueOf('j'), 5), Map.entry(Character.valueOf('k'), 4), Map.entry(Character.valueOf('l'), 2), Map.entry(Character.valueOf('m'), 5), Map.entry(Character.valueOf('n'), 5), Map.entry(Character.valueOf('o'), 5), Map.entry(Character.valueOf('p'), 5), Map.entry(Character.valueOf('q'), 5), Map.entry(Character.valueOf('r'), 4), Map.entry(Character.valueOf('s'), 5), Map.entry(Character.valueOf('t'), 3), Map.entry(Character.valueOf('u'), 5), Map.entry(Character.valueOf('v'), 5), Map.entry(Character.valueOf('w'), 5), Map.entry(Character.valueOf('x'), 5), Map.entry(Character.valueOf('y'), 5), Map.entry(Character.valueOf('z'), 5), Map.entry(Character.valueOf('{'), 3), Map.entry(Character.valueOf('|'), 1), Map.entry(Character.valueOf('}'), 3), Map.entry(Character.valueOf('~'), 6));

    public static List<Component> splitByChar(Component component, char delimiter) {
        ArrayList<Component> result = new ArrayList<Component>();
        ArrayList<Component> currentLine = new ArrayList<Component>();
        TextUtil.splitRecursive(component, delimiter, currentLine, result);
        if (!currentLine.isEmpty()) {
            result.add(Component.empty().children(currentLine));
        }
        return result;
    }

    private static void splitRecursive(Component component, char delimiter, List<Component> currentLine, List<Component> result) {
        if (component instanceof TextComponent) {
            TextComponent textComponent = (TextComponent)component;
            String content = textComponent.content();
            Style style = textComponent.style();
            int start = 0;
            for (int i = 0; i < content.length(); ++i) {
                if (content.charAt(i) != delimiter) continue;
                if (start < i) {
                    String segment = content.substring(start, i);
                    currentLine.add((Component)Component.text((String)segment, (Style)style));
                }
                result.add(Component.empty().children(currentLine));
                currentLine.clear();
                start = i + 1;
            }
            if (start < content.length()) {
                String remaining = content.substring(start);
                currentLine.add((Component)Component.text((String)remaining, (Style)style));
            }
        }
        for (Component child : component.children()) {
            TextUtil.splitRecursive(child, delimiter, currentLine, result);
        }
    }

    public static List<Component> splitLines(Component component, int width) {
        List<Component> lines = TextUtil.splitByChar(component, '\n');
        ArrayList<Component> splitLines = new ArrayList<Component>();
        for (Component line : lines) {
            splitLines.addAll(TextUtil.splitLine(line, width));
        }
        return splitLines;
    }

    private static List<Component> splitLine(Component component, int width) {
        List<Component> words = TextUtil.splitByChar(component, ' ');
        ArrayList<Component> lines = new ArrayList<Component>();
        ArrayList<Component> currentLine = new ArrayList<Component>();
        int currentLineWidth = 0;
        for (Component word : words) {
            int wordWidth = TextUtil.getComponentWidth(word);
            if (currentLineWidth + wordWidth > width) {
                lines.add(Component.empty().children(currentLine));
                currentLine = new ArrayList();
                currentLineWidth = 0;
            }
            currentLineWidth += wordWidth + 4;
            currentLine.add(word.append((Component)Component.text((String)" ")));
        }
        if (!currentLine.isEmpty()) {
            lines.add(Component.empty().children(currentLine));
        }
        return lines;
    }

    private static int getComponentWidth(Component component) {
        if (component instanceof TextComponent) {
            TextComponent textComponent = (TextComponent)component;
            int w = 0;
            for (char c : textComponent.content().toCharArray()) {
                w += TextUtil.getCharWidth(c, textComponent.style());
            }
            return w;
        }
        int w = 0;
        for (Component child : component.children()) {
            w += TextUtil.getComponentWidth(child);
        }
        return w;
    }

    private static int getCharWidth(char c, Style style) {
        int width = CHAR_WIDTHS.getOrDefault(Character.valueOf(c), 5) + 1;
        if (style.decoration(TextDecoration.BOLD) == TextDecoration.State.TRUE) {
            ++width;
        }
        return width;
    }

    public static String joinWithFinalDelimiter(List<String> items, String delimiter, String finalDelimiter) {
        int size = items.size();
        if (size == 0) {
            return "";
        }
        if (size == 1) {
            return items.get(0);
        }
        if (size == 2) {
            return items.get(0) + finalDelimiter + items.get(1);
        }
        return String.join((CharSequence)delimiter, items.subList(0, size - 1)) + finalDelimiter + items.get(size - 1);
    }
}

