/*
 * Decompiled with CFR 0.152.
 */
package com.alignedcookie88.heartbound_smp.util;

import com.alignedcookie88.heartbound_smp.util.TrustUtil;
import java.util.Collection;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class SonicBoomUtil {
    private static final double MAX_RANGE = 15.0;
    private static final double STEP = 0.5;
    private static final double HIT_RADIUS = 1.0;
    private static final double DAMAGE = 15.0;

    public static void fire(Player shooter) {
        Location eye = shooter.getEyeLocation();
        Vector dir = eye.getDirection().normalize();
        World w = shooter.getWorld();
        w.playSound(eye, Sound.ENTITY_WARDEN_SONIC_BOOM, SoundCategory.PLAYERS, 2.0f, 1.0f);
        for (double d = 0.0; d <= 15.0; d += 0.5) {
            Location point = eye.clone().add(dir.clone().multiply(d));
            w.spawnParticle(Particle.SONIC_BOOM, point, 0, 0.0, 0.0, 0.0, 0.0);
            Collection hits = w.getNearbyEntities(point, 1.0, 1.0, 1.0, e -> e instanceof LivingEntity && e != shooter && !e.isDead());
            if (!hits.isEmpty()) {
                Player targetPlayer;
                LivingEntity target = (LivingEntity)hits.iterator().next();
                if (target instanceof Player && !TrustUtil.canPlayersPvp(shooter, targetPlayer = (Player)target)) continue;
                target.damage(15.0, (Entity)shooter);
                Vector push = target.getLocation().toVector().subtract(eye.toVector()).normalize().multiply(1.5);
                target.setVelocity(push);
                break;
            }
            if (w.getBlockAt(point).getType().isSolid()) break;
        }
    }
}

