/*
 * Decompiled with CFR 0.152.
 */
package com.alignedcookie88.heartbound_smp.util;

import java.util.ArrayList;
import org.bukkit.Location;
import org.bukkit.Particle;

public class ParticleUtil {
    public static <T> void particleCircle(Location location, float radius, Particle particle, T options) {
        for (int d = 0; d < 360; ++d) {
            Location particleLoc = new Location(location.getWorld(), location.getX(), location.getY(), location.getZ());
            particleLoc.setX(location.getX() + Math.cos(Math.toRadians(d)) * (double)radius);
            particleLoc.setZ(location.getZ() + Math.sin(Math.toRadians(d)) * (double)radius);
            location.getWorld().spawnParticle(particle, particleLoc, 1, options);
        }
    }

    public static <T> void particleSphere(Location location, float radius, int n, Particle particle, T options) {
        double phi = 2.399963229728653;
        ArrayList<Location> locations = new ArrayList<Location>(n);
        for (int i = 0; i < n; ++i) {
            double z = 1.0 - (2.0 * (double)i + 1.0) / (double)n;
            double r = Math.sqrt(1.0 - z * z);
            double az = 2.399963229728653 * (double)i;
            double x = (double)radius * r * Math.cos(az);
            double y = (double)radius * r * Math.sin(az);
            double zz = (double)radius * z;
            locations.add(new Location(location.getWorld(), location.getX() + x, location.getY() + y, location.getZ() + zz));
        }
        for (Location particleLoc : locations) {
            particleLoc.getWorld().spawnParticle(particle, particleLoc, 1, 0.0, 0.0, 0.0, 0.0, options);
        }
    }
}

