/*
 * Decompiled with CFR 0.152.
 */
package com.alignedcookie88.heartbound_smp.pedestal;

import com.alignedcookie88.heartbound_smp.CustomItem;
import com.alignedcookie88.heartbound_smp.HeartboundSMP;
import com.alignedcookie88.heartbound_smp.Infusion;
import com.alignedcookie88.heartbound_smp.crafting.ItemMatcher;
import com.alignedcookie88.heartbound_smp.util.InfusionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PedestalRecipe {
    private static final List<PedestalRecipe> recipes = new ArrayList<PedestalRecipe>();
    public final List<ItemMatcher> ingredients;
    private final ResultSupplier resultSupplier;
    private String advancementKey = null;

    public static void setupRecipes() {
        PedestalRecipe.register(new PedestalRecipe(List.of(ItemMatcher.vanilla(Material.TOTEM_OF_UNDYING), ItemMatcher.custom(HeartboundSMP.TOTEM_OF_ASCENT), ItemMatcher.custom(HeartboundSMP.TOTEM_OF_WITHERING), ItemMatcher.custom(HeartboundSMP.TOTEM_OF_SUBMERSION), ItemMatcher.custom(HeartboundSMP.TOTEM_OF_RESONANCE), ItemMatcher.custom(HeartboundSMP.TOTEM_OF_WAFTING)), HeartboundSMP.MEGATOTEM.getStack()));
        ItemStack kb2dirt = new ItemStack(Material.DIRT);
        kb2dirt.editMeta(meta -> meta.addEnchant(Enchantment.KNOCKBACK, 2, true));
        PedestalRecipe.register(new PedestalRecipe(List.of(ItemMatcher.vanilla(Material.DIRT), ItemMatcher.vanilla(Material.DIRT), ItemMatcher.vanilla(Material.DIRT), ItemMatcher.vanilla(Material.DIRT), ItemMatcher.vanilla(Material.DIRT), ItemMatcher.vanilla(Material.DIRT)), kb2dirt));
        PedestalRecipe.register(new PedestalRecipe(List.of(ItemMatcher.vanilla(Material.COAL), ItemMatcher.vanilla(Material.LAVA_BUCKET)), new ItemStack(Material.DIAMOND)));
        PedestalRecipe.register(new PedestalRecipe(List.of(ItemMatcher.vanilla(Material.NETHERITE_INGOT), ItemMatcher.vanilla(Material.NETHERITE_INGOT), ItemMatcher.vanilla(Material.NETHERITE_INGOT), ItemMatcher.vanilla(Material.NETHERITE_INGOT), ItemMatcher.vanilla(Material.NETHERITE_INGOT), ItemMatcher.vanilla(Material.NETHERITE_INGOT)), new ItemStack(Material.ANCIENT_DEBRIS)).withAdvancement("hbsmp:serious_incompetence"));
        PedestalRecipe.register(new PedestalRecipe(List.of(ItemMatcher.vanilla(Material.GOLDEN_APPLE), ItemMatcher.vanilla(Material.NETHERITE_INGOT), ItemMatcher.vanilla(Material.GOLDEN_APPLE), ItemMatcher.vanilla(Material.NETHERITE_INGOT), ItemMatcher.vanilla(Material.GOLDEN_APPLE), ItemMatcher.vanilla(Material.NETHERITE_INGOT)), new ItemStack(Material.ENCHANTED_GOLDEN_APPLE)).withAdvancement("hbsmp:fruity_fusion"));
        PedestalRecipe.register(new PedestalRecipe(List.of(ItemMatcher.vanilla(Material.NETHERITE_INGOT), ItemMatcher.vanilla(Material.DIAMOND_BLOCK), ItemMatcher.vanilla(Material.NETHERITE_INGOT), ItemMatcher.vanilla(Material.DIAMOND_BLOCK), ItemMatcher.vanilla(Material.NETHERITE_INGOT), ItemMatcher.vanilla(Material.DIAMOND_BLOCK)), HeartboundSMP.OVERENCHANTING_CRYSTAL.getStack()));
        PedestalRecipe.register(PedestalRecipe.infusionRecipe(HeartboundSMP.PRISM_OF_REAPING, Infusion.REAPING));
        PedestalRecipe.register(new PedestalRecipe(List.of(ItemMatcher.custom(HeartboundSMP.OVERENCHANTING_CRYSTAL), ItemMatcher.vanilla(Material.ENCHANTED_BOOK).withIdentifier("book"), ItemMatcher.custom(HeartboundSMP.OVERENCHANTING_CRYSTAL).or(ItemMatcher.vanilla(Material.ENCHANTED_BOOK)).not().withIdentifier("item")), suppliedItems -> {
            ItemStack book = suppliedItems.getStack("book");
            ItemStack item = suppliedItems.getStack("item");
            Map enchantments = ((EnchantmentStorageMeta)book.getItemMeta()).getStoredEnchants();
            int minLevel = Integer.MAX_VALUE;
            ArrayList<Enchantment> valid = new ArrayList<Enchantment>();
            for (Map.Entry entry : enchantments.entrySet()) {
                int level = (Integer)entry.getValue();
                if (level < minLevel) {
                    minLevel = level;
                    valid.clear();
                    valid.add((Enchantment)entry.getKey());
                    continue;
                }
                if (level != minLevel) continue;
                valid.add((Enchantment)entry.getKey());
            }
            HeartboundSMP.plugin.getLogger().info("Valid: " + String.valueOf(valid));
            HeartboundSMP.plugin.getLogger().info("Level: " + minLevel);
            if (valid.isEmpty()) {
                return item;
            }
            Enchantment chosen = (Enchantment)valid.get(new Random().nextInt(valid.size()));
            ItemMeta meta = item.getItemMeta();
            meta.addEnchant(chosen, minLevel + 1, true);
            item.setItemMeta(meta);
            return item;
        }));
    }

    private static PedestalRecipe infusionRecipe(CustomItem prism, Infusion infusion) {
        return new PedestalRecipe(List.of(ItemMatcher.custom(prism), ItemMatcher.custom(prism).not().withIdentifier("result")), suppliedItems -> {
            ItemStack result = suppliedItems.getStack("result");
            assert (result != null);
            return InfusionUtil.infuse(result, infusion);
        });
    }

    private static void register(PedestalRecipe recipe) {
        recipes.add(recipe);
    }

    public static Collection<PedestalRecipe> recipes() {
        return List.copyOf(recipes);
    }

    public PedestalRecipe(List<ItemMatcher> ingredients, ItemStack result) {
        this(ingredients, (SuppliedItems suppliedItems) -> result);
    }

    public PedestalRecipe(List<ItemMatcher> ingredients, ResultSupplier resultSupplier) {
        this.ingredients = ingredients;
        this.resultSupplier = resultSupplier;
    }

    public PedestalRecipe withAdvancement(String key) {
        this.advancementKey = key;
        return this;
    }

    public String getAdvancementKey() {
        return this.advancementKey;
    }

    public ItemStack getResult(Map<ItemMatcher, ItemStack> suppliedItems) {
        return this.resultSupplier.getResult((String identifier) -> {
            for (ItemMatcher matcher : suppliedItems.keySet()) {
                if (!identifier.equals(matcher.identifier())) continue;
                return ((ItemStack)suppliedItems.get(matcher)).clone();
            }
            return null;
        }).clone();
    }

    public static interface ResultSupplier {
        public ItemStack getResult(SuppliedItems var1);
    }

    public static interface SuppliedItems {
        @Nullable
        public ItemStack getStack(@NotNull String var1);
    }
}

