/*
 * Decompiled with CFR 0.152.
 */
package com.alignedcookie88.heartbound_smp.pedestal;

import com.alignedcookie88.heartbound_smp.HeartboundSMP;
import com.alignedcookie88.heartbound_smp.crafting.ItemMatcher;
import com.alignedcookie88.heartbound_smp.pedestal.AmethystPedestalManager;
import com.alignedcookie88.heartbound_smp.pedestal.PedestalRecipe;
import com.alignedcookie88.heartbound_smp.util.AdvancementUtil;
import com.alignedcookie88.heartbound_smp.util.LocationUtil;
import com.alignedcookie88.heartbound_smp.util.ParticleUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.entity.Item;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.joml.Vector3i;

public class PedestalCircle {
    private static final List<List<Vector3i>> offsets = List.of(List.of(new Vector3i(4, 0, -2), new Vector3i(0, 0, -4), new Vector3i(-4, 0, -2), new Vector3i(-4, 0, 2), new Vector3i(0, 0, 4), new Vector3i(4, 0, 2)), List.of(new Vector3i(-2, 0, 4), new Vector3i(-4, 0, 0), new Vector3i(-2, 0, -4), new Vector3i(2, 0, -4), new Vector3i(4, 0, 0), new Vector3i(2, 0, 4)));
    private final List<Location> pedestals;
    private final Location rod;

    public static void checkAndCraftAroundPedestal(Location pedestal) {
        PedestalCircle circle = PedestalCircle.findFromPedestal(pedestal);
        if (circle == null) {
            return;
        }
        circle.checkAndCraft();
    }

    public static PedestalCircle findFromPedestal(Location pedestal) {
        for (List<Vector3i> shape : offsets) {
            for (Vector3i point : shape) {
                PedestalCircle circle;
                Directional directional;
                BlockData blockData;
                Location rodLocation = LocationUtil.sub(pedestal, point);
                if (rodLocation.getBlock().getType() != Material.LIGHTNING_ROD || !((blockData = rodLocation.getBlock().getBlockData()) instanceof Directional) || (directional = (Directional)blockData).getFacing() != BlockFace.UP || (circle = PedestalCircle.getFromShape(shape, rodLocation)) == null) continue;
                return circle;
            }
        }
        return null;
    }

    private static PedestalCircle getFromShape(List<Vector3i> shape, Location rod) {
        ArrayList<Location> pedestals = new ArrayList<Location>();
        for (Vector3i pedestalOffset : shape) {
            Location pedestal = LocationUtil.add(rod, pedestalOffset);
            pedestals.add(pedestal);
            if (AmethystPedestalManager.isValidPedestal(pedestal.getBlock())) continue;
            return null;
        }
        return new PedestalCircle(pedestals, rod);
    }

    private PedestalCircle(List<Location> pedestals, Location rod) {
        this.pedestals = pedestals;
        this.rod = rod;
    }

    public void checkAndCraft() {
        Map<Location, ItemStack> stacks = this.getStacks();
        for (PedestalRecipe recipe : PedestalRecipe.recipes()) {
            ArrayList<ItemStack> stacksLeft = new ArrayList<ItemStack>(stacks.values());
            HashMap<Location, ItemStack> ingredients = new HashMap<Location, ItemStack>();
            HashMap<ItemMatcher, ItemStack> suppliedItems = new HashMap<ItemMatcher, ItemStack>();
            boolean hasItems = true;
            for (ItemMatcher matcher : recipe.ingredients) {
                ItemStack found = null;
                for (ItemStack stack : stacksLeft) {
                    if (!matcher.matches(stack)) continue;
                    suppliedItems.put(matcher, stack);
                    found = stack;
                    break;
                }
                if (found != null) {
                    stacksLeft.remove(found);
                    for (Location location : stacks.keySet()) {
                        if (found != stacks.get(location)) continue;
                        ingredients.put(location, found);
                    }
                    continue;
                }
                hasItems = false;
                break;
            }
            if (!hasItems) continue;
            this.craft(ingredients, suppliedItems, recipe);
            break;
        }
    }

    private Map<Location, ItemStack> getStacks() {
        HashMap<Location, ItemStack> stacks = new HashMap<Location, ItemStack>();
        for (Location pedestal : this.pedestals) {
            ItemStack stack = AmethystPedestalManager.getStack(pedestal);
            if (stack == null) continue;
            stacks.put(pedestal, stack);
        }
        return stacks;
    }

    private void craft(Map<Location, ItemStack> stacks, Map<ItemMatcher, ItemStack> suppliedItems, PedestalRecipe recipe) {
        int targetTicks = 50;
        int pauseTicks = 10;
        Location targetLocation = this.rod.clone().add(0.5, 3.0, 0.5);
        Location lightningLocation = this.rod.clone().add(0.5, 1.0, 0.5);
        for (Location pedestal : stacks.keySet()) {
            Item entity = AmethystPedestalManager.takeItemEntityOwnership(pedestal);
            if (entity == null) continue;
            entity.getWorld().spawnParticle(Particle.CLOUD, entity.getLocation(), 10, 0.0, 0.0, 0.0, 0.1);
            Vector difference = targetLocation.toVector().subtract(entity.getLocation().toVector());
            Vector velocity = difference.clone().divide(new Vector(targetTicks, targetTicks, targetTicks));
            entity.setVelocity(velocity);
            int[] counter = new int[]{0};
            Bukkit.getScheduler().runTaskTimer((Plugin)HeartboundSMP.plugin, task -> {
                if (!entity.isDead()) {
                    entity.setVelocity(velocity);
                } else {
                    task.cancel();
                }
                counter[0] = counter[0] + 1;
                if (counter[0] >= targetTicks) {
                    entity.setVelocity(new Vector(0, 0, 0));
                    Bukkit.getScheduler().runTaskLater((Plugin)HeartboundSMP.plugin, task2 -> entity.remove(), (long)pauseTicks);
                    task.cancel();
                }
            }, 0L, 1L);
        }
        int[] counter2 = new int[]{0};
        Bukkit.getScheduler().runTaskTimer((Plugin)HeartboundSMP.plugin, task -> {
            double progress = (double)counter2[0] / (double)targetTicks;
            double size = 1.0 - Math.pow(progress, 4.0);
            double radius = size * 10.0;
            ParticleUtil.particleSphere(targetLocation, (float)radius, 500, Particle.END_ROD, null);
            counter2[0] = counter2[0] + 1;
            if (counter2[0] >= targetTicks) {
                task.cancel();
            }
        }, 0L, 1L);
        Bukkit.getScheduler().runTaskLater((Plugin)HeartboundSMP.plugin, task -> {
            targetLocation.getWorld().spawnParticle(Particle.EXPLOSION_EMITTER, targetLocation, 3);
            LightningStrike strike = lightningLocation.getWorld().strikeLightning(lightningLocation);
            strike.setFlashCount(stacks.size());
            Item item = targetLocation.getWorld().dropItem(targetLocation, recipe.getResult(suppliedItems));
            item.setInvulnerable(true);
            item.setVisualFire(true);
            item.setPersistent(true);
            item.setCanMobPickup(false);
            item.setPickupDelay(40);
            for (Player player : targetLocation.getNearbyPlayers(20.0)) {
                AdvancementUtil.grant(player, "hbsmp:electric_fusion");
                if (recipe.getAdvancementKey() == null) continue;
                AdvancementUtil.grant(player, recipe.getAdvancementKey());
            }
        }, (long)(targetTicks + pauseTicks));
    }
}

