/*
 * Decompiled with CFR 0.152.
 */
package com.alignedcookie88.heartbound_smp.pedestal;

import com.alignedcookie88.heartbound_smp.HeartboundSMP;
import com.alignedcookie88.heartbound_smp.pedestal.PedestalCircle;
import com.alignedcookie88.heartbound_smp.util.AdvancementUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.entity.Item;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AmethystPedestalManager {
    private static final HashMap<Location, Integer> lastUpdateTicks = new HashMap();
    private static final List<Location> knownClusters = new ArrayList<Location>();
    private static final NamespacedKey key = new NamespacedKey((Plugin)HeartboundSMP.plugin, "is_pedestal_item");

    @NotNull
    private static Location getItemLocation(@NotNull Location blockLocation) {
        return new Location(blockLocation.getWorld(), (double)blockLocation.getBlockX() + 0.5, (double)blockLocation.getBlockY() + 0.9, (double)blockLocation.getBlockZ() + 0.5);
    }

    @Nullable
    private static Item getItemEntity(@NotNull Location location) {
        Location itemLocation = AmethystPedestalManager.getItemLocation(location);
        Collection items = location.getWorld().getNearbyEntitiesByType(Item.class, itemLocation, 0.1, item -> Boolean.TRUE.equals(item.getPersistentDataContainer().get(key, PersistentDataType.BOOLEAN)));
        Iterator iterator = items.iterator();
        if (iterator.hasNext()) {
            Item item2 = (Item)iterator.next();
            return item2;
        }
        return null;
    }

    public static boolean isValidPedestal(@Nullable Block block) {
        if (block == null) {
            return false;
        }
        BlockData data = block.getBlockData();
        if (data instanceof Directional) {
            Directional directional = (Directional)data;
            return block.getType() == Material.AMETHYST_CLUSTER && directional.getFacing() == BlockFace.UP;
        }
        return false;
    }

    @Nullable
    public static ItemStack getStack(@NotNull Location location) {
        Item entity = AmethystPedestalManager.getItemEntity(location);
        if (entity != null) {
            return entity.getItemStack();
        }
        return null;
    }

    public static boolean isEmpty(@NotNull Location location) {
        ItemStack stack = AmethystPedestalManager.getStack(location);
        return stack == null || stack.isEmpty();
    }

    public static void setStack(@NotNull Location location, @Nullable ItemStack stack) {
        AmethystPedestalManager.setStack(location, stack, false);
    }

    public static void setStack(@NotNull Location location, @Nullable ItemStack stack, boolean silent) {
        if (stack != null && stack.isEmpty()) {
            stack = null;
        }
        Item existing = AmethystPedestalManager.getItemEntity(location);
        if (!silent) {
            float pitch_mod = (float)(Math.random() * 0.4 - 0.2);
            if (stack != null) {
                location.getWorld().playSound(location, "hbsmp:pedestal_insert", 1.0f, 1.0f + pitch_mod);
            } else if (existing != null) {
                location.getWorld().playSound(location, "hbsmp:pedestal_remove", 1.0f, 1.0f + pitch_mod);
            }
        }
        if (existing != null) {
            existing.remove();
        }
        if (stack != null) {
            Location itemLocation = AmethystPedestalManager.getItemLocation(location);
            Item item = location.getWorld().dropItem(itemLocation, stack);
            item.setGravity(false);
            item.setPickupDelay(Integer.MAX_VALUE);
            item.setCanMobPickup(false);
            item.setCanPlayerPickup(false);
            item.setInvulnerable(true);
            item.setVelocity(item.getVelocity().zero());
            item.setPersistent(true);
            item.setUnlimitedLifetime(true);
            PersistentDataContainer pdc = item.getPersistentDataContainer();
            pdc.set(key, PersistentDataType.BOOLEAN, (Object)true);
        }
        PedestalCircle.checkAndCraftAroundPedestal(location);
    }

    public static Item takeItemEntityOwnership(@NotNull Location location) {
        Item entity = AmethystPedestalManager.getItemEntity(location);
        if (entity == null) {
            return null;
        }
        PersistentDataContainer pdc = entity.getPersistentDataContainer();
        pdc.set(key, PersistentDataType.BOOLEAN, (Object)false);
        return entity;
    }

    public static void handleClick(PlayerInteractEvent event) {
        Location location = event.getClickedBlock().getLocation();
        Location itemLocation = AmethystPedestalManager.getItemLocation(location);
        Integer lastUpdateTick = lastUpdateTicks.getOrDefault(itemLocation, 0);
        if (lastUpdateTick == Bukkit.getCurrentTick()) {
            event.setCancelled(true);
            return;
        }
        lastUpdateTicks.put(itemLocation, Bukkit.getCurrentTick());
        ItemStack handStack = event.getPlayer().getInventory().getItemInMainHand();
        ItemStack targetStack = handStack.clone();
        targetStack.setAmount(1);
        if (!handStack.isEmpty()) {
            AdvancementUtil.grant(event.getPlayer(), "hbsmp:very_fancy");
        }
        ItemStack currentStack = AmethystPedestalManager.getStack(location);
        AmethystPedestalManager.setStack(location, targetStack);
        if (currentStack != null && event.getPlayer().getGameMode() != GameMode.CREATIVE) {
            event.getPlayer().give(new ItemStack[]{currentStack});
        }
        if (event.getPlayer().getGameMode() != GameMode.CREATIVE) {
            handStack.setAmount(handStack.getAmount() - 1);
        }
        event.setCancelled(true);
    }

    public static void updateBlock(Block block, Material changedType) {
        Location location = block.getLocation();
        if (AmethystPedestalManager.isValidPedestal(block)) {
            if (!knownClusters.contains(location)) {
                knownClusters.add(location);
            }
        } else if (knownClusters.contains(location) || changedType == Material.AMETHYST_CLUSTER) {
            knownClusters.remove(location);
            ItemStack stack = AmethystPedestalManager.getStack(location);
            if (stack != null && !stack.isEmpty()) {
                AmethystPedestalManager.setStack(location, null);
                location.getWorld().dropItemNaturally(location, stack);
            }
        }
    }
}

