/*
 * Decompiled with CFR 0.152.
 */
package com.alignedcookie88.heartbound_smp.lore;

import com.alignedcookie88.heartbound_smp.util.TextUtil;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;

public class LoreSection {
    private final Component name;
    private Component description;
    private final List<Component> points = new ArrayList<Component>();

    public LoreSection(String name) {
        this(MiniMessage.miniMessage().deserialize((Object)name));
    }

    public LoreSection(Component name) {
        this.name = ((TextComponent)Component.empty().style(Style.style().decoration(TextDecoration.ITALIC, TextDecoration.State.FALSE).color((TextColor)NamedTextColor.GRAY).build())).append(name);
    }

    public LoreSection withDescription(String description) {
        return this.withDescription(MiniMessage.miniMessage().deserialize((Object)description));
    }

    public LoreSection withDescription(Component description) {
        this.description = description;
        return this;
    }

    public LoreSection withPoint(Component name, Component value) {
        this.points.add(((TextComponent)((TextComponent)((TextComponent)Component.empty().style(Style.style().decoration(TextDecoration.ITALIC, TextDecoration.State.FALSE).color((TextColor)NamedTextColor.GRAY).build())).append(name)).append(Component.text((String)" \u00bb ").color((TextColor)NamedTextColor.DARK_GRAY))).append(((TextComponent)Component.empty().color((TextColor)NamedTextColor.WHITE)).append(value)));
        return this;
    }

    public List<Component> getLore() {
        ArrayList<Component> lore = new ArrayList<Component>();
        lore.add(((TextComponent)Component.empty().append(MiniMessage.miniMessage().deserialize((Object)"<!italic><dark_gray><bold><font:hbsmp:symbols>c</font> "))).append(this.name));
        if (this.description != null) {
            for (Component line : TextUtil.splitLines(this.description, 30)) {
                lore.add(((TextComponent)Component.empty().style(Style.style().decoration(TextDecoration.ITALIC, TextDecoration.State.FALSE).color((TextColor)NamedTextColor.GRAY).build())).append(line));
            }
        }
        lore.addAll(this.points);
        return lore;
    }
}

