/*
 * Decompiled with CFR 0.152.
 */
package com.alignedcookie88.heartbound_smp.lore;

import com.alignedcookie88.heartbound_smp.lore.LoreBadge;
import com.alignedcookie88.heartbound_smp.lore.LoreSection;
import com.alignedcookie88.heartbound_smp.util.TextUtil;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;

public class LoreBuilder {
    private Component description = null;
    private final List<LoreSection> sections = new ArrayList<LoreSection>();
    private final List<LoreBadge> badges = new ArrayList<LoreBadge>();

    private LoreBuilder() {
    }

    public static LoreBuilder create() {
        return new LoreBuilder();
    }

    public LoreBuilder withDescription(String description) {
        this.description = MiniMessage.miniMessage().deserialize((Object)("<!italic><gray>" + description));
        return this;
    }

    public LoreBuilder withDescription(Component description) {
        this.description = ((TextComponent)Component.empty().style(Style.style().decoration(TextDecoration.ITALIC, TextDecoration.State.FALSE).color((TextColor)NamedTextColor.GRAY).build())).append(description);
        return this;
    }

    public LoreBuilder withSection(LoreSection section) {
        this.sections.add(section);
        return this;
    }

    public LoreBuilder withBadge(LoreBadge badge) {
        this.badges.add(badge);
        return this;
    }

    public List<Component> build() {
        ArrayList<Component> lines = new ArrayList<Component>();
        boolean nextNewline = false;
        if (this.description != null) {
            lines.addAll(TextUtil.splitLines(this.description, 30));
            nextNewline = true;
        }
        for (LoreSection section : this.sections) {
            lines.add((Component)Component.empty());
            nextNewline = true;
            lines.addAll(section.getLore());
        }
        if (!this.badges.isEmpty()) {
            if (nextNewline) {
                lines.add((Component)Component.empty());
            }
            for (LoreBadge badge : this.badges) {
                lines.add(badge.getLine());
            }
        }
        return lines;
    }
}

