/*
 * Decompiled with CFR 0.152.
 */
package com.alignedcookie88.heartbound_smp.crafting.recipe;

import com.alignedcookie88.heartbound_smp.crafting.CraftingUtils;
import com.alignedcookie88.heartbound_smp.crafting.ItemMatcher;
import com.alignedcookie88.heartbound_smp.crafting.recipe.Recipe;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ShapedRecipe
implements Recipe {
    public final int width;
    public final int height;
    public final Character[][] recipe;
    public final Map<Character, ItemMatcher> matcherMap;
    public final ItemStack result;

    private static Character[][] charArray2FromStringArray(String[] stringArray) {
        Character[][] charArray2 = new Character[stringArray.length][];
        int i = 0;
        for (String line : stringArray) {
            charArray2[i] = ArrayUtils.toObject((char[])line.toCharArray());
            ++i;
        }
        return charArray2;
    }

    public ShapedRecipe(String[] recipe, Map<Character, ItemMatcher> matcherMap, ItemStack result) {
        this(ShapedRecipe.charArray2FromStringArray(recipe), matcherMap, result);
    }

    public ShapedRecipe(Character[][] recipe, Map<Character, ItemMatcher> matcherMap, ItemStack result) {
        this.width = CraftingUtils.getGridWidth(recipe);
        this.height = CraftingUtils.getGridHeight(recipe);
        this.recipe = recipe;
        this.matcherMap = matcherMap;
        this.result = result;
    }

    @Override
    public ItemStack craft(ItemStack[][] grid, ItemStack[][] shrunkGrid, Player player) {
        int sw = CraftingUtils.getGridWidth(shrunkGrid);
        int sh = CraftingUtils.getGridHeight(shrunkGrid);
        if (this.width != sw) {
            return null;
        }
        if (this.height != sh) {
            return null;
        }
        boolean matches = true;
        for (int x = 0; x < this.width && matches; ++x) {
            for (int y = 0; y < this.height && matches; ++y) {
                ItemMatcher matcher = this.matcherMap.getOrDefault(this.recipe[y][x], ItemMatcher.always(false));
                ItemStack stack = shrunkGrid[y][x];
                matches = matcher.matches(stack);
            }
        }
        return matches ? this.result : null;
    }
}

