/*
 * Decompiled with CFR 0.152.
 */
package com.alignedcookie88.heartbound_smp.crafting;

import com.alignedcookie88.heartbound_smp.CustomItem;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public interface ItemMatcher {
    public static ItemMatcher vanilla(Material material) {
        return stack -> stack != null && stack.getType().equals((Object)material);
    }

    public static ItemMatcher custom(CustomItem item) {
        return stack -> stack != null && CustomItem.fromStack(stack) == item;
    }

    public static ItemMatcher empty() {
        return stack -> stack == null || stack.isEmpty();
    }

    public static ItemMatcher always(boolean matches) {
        return stack -> matches;
    }

    public boolean matches(@Nullable ItemStack var1);

    default public String identifier() {
        return null;
    }

    default public ItemMatcher withIdentifier(final String identifier) {
        final ItemMatcher outer = this;
        return new ItemMatcher(){

            @Override
            public boolean matches(@Nullable ItemStack stack) {
                return outer.matches(stack);
            }

            @Override
            public String identifier() {
                return identifier;
            }
        };
    }

    default public ItemMatcher not() {
        final ItemMatcher outer = this;
        return new ItemMatcher(){

            @Override
            public boolean matches(@Nullable ItemStack stack) {
                return !outer.matches(stack);
            }

            @Override
            public String identifier() {
                return outer.identifier();
            }
        };
    }

    default public ItemMatcher and(final ItemMatcher other) {
        final ItemMatcher outer = this;
        return new ItemMatcher(){

            @Override
            public boolean matches(@Nullable ItemStack stack) {
                return outer.matches(stack) && other.matches(stack);
            }

            @Override
            public String identifier() {
                return outer.identifier();
            }
        };
    }

    default public ItemMatcher or(final ItemMatcher other) {
        final ItemMatcher outer = this;
        return new ItemMatcher(){

            @Override
            public boolean matches(@Nullable ItemStack stack) {
                return outer.matches(stack) || other.matches(stack);
            }

            @Override
            public String identifier() {
                return outer.identifier();
            }
        };
    }
}

