/*
 * Decompiled with CFR 0.152.
 */
package com.alignedcookie88.heartbound_smp.crafting;

import java.lang.reflect.Array;
import java.util.function.Predicate;

public class CraftingUtils {
    public static <T> int getGridWidth(T[][] array) {
        if (array.length == 0) {
            return 0;
        }
        int width = -1;
        for (T[] row : array) {
            if (width != -1 && row.length != width) {
                throw new IllegalArgumentException("The provided rows differ in width");
            }
            width = row.length;
        }
        return width;
    }

    public static <T> int getGridHeight(T[][] array) {
        return array.length;
    }

    public static <T> T[][] shrinkGrid(T[][] grid, Predicate<T> isNotRequired) {
        int right;
        int left;
        int bottom;
        int top;
        int totalRows = grid.length;
        if (totalRows == 0) {
            return grid;
        }
        for (top = 0; top < totalRows && CraftingUtils.isRowUseless(grid[top], isNotRequired); ++top) {
        }
        for (bottom = totalRows - 1; bottom >= top && CraftingUtils.isRowUseless(grid[bottom], isNotRequired); --bottom) {
        }
        if (top > bottom) {
            Object[][] empty = (Object[][])Array.newInstance(grid.getClass().getComponentType(), 0);
            return empty;
        }
        int maxCols = 0;
        for (T[] row : grid) {
            maxCols = Math.max(maxCols, row.length);
        }
        for (left = 0; left < maxCols && CraftingUtils.isColumnUseless(grid, left, top, bottom, isNotRequired); ++left) {
        }
        for (right = maxCols - 1; right >= left && CraftingUtils.isColumnUseless(grid, right, top, bottom, isNotRequired); --right) {
        }
        int newRows = bottom - top + 1;
        int newCols = right - left + 1;
        Object[][] trimmed = (Object[][])Array.newInstance(grid.getClass().getComponentType(), newRows);
        for (int r = 0; r < newRows; ++r) {
            T[] src = grid[top + r];
            Object[] destRow = (Object[])Array.newInstance(src.getClass().getComponentType(), newCols);
            if (src.length > left) {
                int copy = Math.min(newCols, src.length - left);
                System.arraycopy(src, left, destRow, 0, copy);
            }
            trimmed[r] = destRow;
        }
        return trimmed;
    }

    private static <T> boolean isRowUseless(T[] row, Predicate<T> isNotRequired) {
        for (T v : row) {
            if (isNotRequired.test(v)) continue;
            return false;
        }
        return true;
    }

    private static <T> boolean isColumnUseless(T[][] grid, int col, int top, int bottom, Predicate<T> isNotRequired) {
        for (int r = top; r <= bottom; ++r) {
            T[] row = grid[r];
            if (col >= row.length || isNotRequired.test(row[col])) continue;
            return false;
        }
        return true;
    }
}

