/*
 * Decompiled with CFR 0.152.
 */
package com.alignedcookie88.heartbound_smp.crafting;

import com.alignedcookie88.heartbound_smp.HeartboundSMP;
import com.alignedcookie88.heartbound_smp.crafting.CraftingUtils;
import com.alignedcookie88.heartbound_smp.crafting.ItemMatcher;
import com.alignedcookie88.heartbound_smp.crafting.recipe.Recipe;
import com.alignedcookie88.heartbound_smp.crafting.recipe.ShapedRecipe;
import com.alignedcookie88.heartbound_smp.util.MapBuilder;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.ItemStack;

public class CraftingManager {
    private static final List<Recipe> recipes = new ArrayList<Recipe>();

    public static void setupRecipes() {
        CraftingManager.register(new ShapedRecipe(new String[]{"YEY", "OHO", "YEY"}, MapBuilder.create(Character.class, ItemMatcher.class).with(Character.valueOf('Y'), ItemMatcher.vanilla(Material.ENDER_EYE)).with(Character.valueOf('E'), ItemMatcher.vanilla(Material.ELYTRA)).with(Character.valueOf('O'), ItemMatcher.vanilla(Material.OBSIDIAN)).with(Character.valueOf('H'), ItemMatcher.custom(HeartboundSMP.DRAGON_HEART)).build(), HeartboundSMP.TOTEM_OF_ASCENT.getStack()));
        CraftingManager.register(new ShapedRecipe(new String[]{"SKS", "HQH", "SFS"}, MapBuilder.create(Character.class, ItemMatcher.class).with(Character.valueOf('S'), ItemMatcher.vanilla(Material.SOUL_SAND)).with(Character.valueOf('K'), ItemMatcher.vanilla(Material.WITHER_SKELETON_SKULL)).with(Character.valueOf('H'), ItemMatcher.custom(HeartboundSMP.WITHER_HEART)).with(Character.valueOf('Q'), ItemMatcher.vanilla(Material.QUARTZ)).with(Character.valueOf('F'), ItemMatcher.vanilla(Material.SOUL_CAMPFIRE)).build(), HeartboundSMP.TOTEM_OF_WITHERING.getStack()));
        CraftingManager.register(new ShapedRecipe(new String[]{"LSL", "HDH", "LHL"}, MapBuilder.create(Character.class, ItemMatcher.class).with(Character.valueOf('L'), ItemMatcher.vanilla(Material.SEA_LANTERN)).with(Character.valueOf('S'), ItemMatcher.vanilla(Material.PRISMARINE_BRICK_SLAB)).with(Character.valueOf('H'), ItemMatcher.custom(HeartboundSMP.ELDER_GUARDIAN_HEART)).with(Character.valueOf('D'), ItemMatcher.vanilla(Material.DARK_PRISMARINE)).build(), HeartboundSMP.TOTEM_OF_SUBMERSION.getStack()));
        CraftingManager.register(new ShapedRecipe(new String[]{"SNS", "RHR", "CNC"}, MapBuilder.create(Character.class, ItemMatcher.class).with(Character.valueOf('S'), ItemMatcher.vanilla(Material.SCULK)).with(Character.valueOf('N'), ItemMatcher.vanilla(Material.SCULK_SENSOR)).with(Character.valueOf('R'), ItemMatcher.vanilla(Material.SCULK_SHRIEKER)).with(Character.valueOf('H'), ItemMatcher.custom(HeartboundSMP.WARDEN_HEART)).with(Character.valueOf('C'), ItemMatcher.vanilla(Material.SCULK_CATALYST)).build(), HeartboundSMP.TOTEM_OF_RESONANCE.getStack()));
        CraftingManager.register(new ShapedRecipe(new String[]{"HCH", "RUR", "III"}, MapBuilder.create(Character.class, ItemMatcher.class).with(Character.valueOf('H'), ItemMatcher.custom(HeartboundSMP.BREEZE_HEART)).with(Character.valueOf('C'), ItemMatcher.vanilla(Material.HEAVY_CORE)).with(Character.valueOf('R'), ItemMatcher.vanilla(Material.BREEZE_ROD)).with(Character.valueOf('U'), ItemMatcher.vanilla(Material.CUT_COPPER)).with(Character.valueOf('I'), ItemMatcher.vanilla(Material.CHISELED_COPPER)).build(), HeartboundSMP.TOTEM_OF_WAFTING.getStack()));
    }

    private static void register(Recipe recipe) {
        recipes.add(recipe);
    }

    public static ItemStack craft(ItemStack[][] grid, Player player) {
        ItemStack[][] shrunk = CraftingUtils.shrinkGrid(grid, stack -> stack == null || stack.isEmpty());
        for (Recipe recipe : recipes) {
            ItemStack result = recipe.craft(grid, shrunk, player);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static ItemStack craft(CraftingInventory inventory, Player player) {
        ItemStack[] matrix = inventory.getMatrix();
        if (inventory.getType() == InventoryType.CRAFTING) {
            return CraftingManager.craft(new ItemStack[][]{{matrix[0], matrix[1]}, {matrix[2], matrix[3]}}, player);
        }
        if (inventory.getType() == InventoryType.WORKBENCH) {
            return CraftingManager.craft(new ItemStack[][]{{matrix[0], matrix[1], matrix[2]}, {matrix[3], matrix[4], matrix[5]}, {matrix[6], matrix[7], matrix[8]}}, player);
        }
        return null;
    }
}

