/*
 * Decompiled with CFR 0.152.
 */
package com.alignedcookie88.heartbound_smp.buffs.type;

import com.alignedcookie88.heartbound_smp.buffs.type.BuffType;
import com.alignedcookie88.heartbound_smp.util.TrustUtil;
import java.util.HashMap;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class EavesdroppingBuff
extends BuffType {
    private static final HashMap<String, Integer> pTicks = new HashMap();

    EavesdroppingBuff() {
        super("<#0b875e>Eavesdropping");
    }

    @Override
    public void enable(Player player) {
    }

    @Override
    public void disable(Player player) {
    }

    @Override
    public void tick(Player player) {
        Location loc = player.getLocation();
        Location eye = player.getEyeLocation();
        for (Player other : player.getWorld().getPlayers()) {
            if (other.getEntityId() == player.getEntityId() || other.isSneaking() || TrustUtil.playerTrusts(player, other)) continue;
            String key = player.getEntityId() + ";" + other.getEntityId();
            int ticks = pTicks.getOrDefault(key, 0);
            ++ticks;
            double distance = loc.distance(other.getLocation());
            if (distance > 50.0) continue;
            int frequency = (int)(distance / 50.0 * 16.0 + 5.0);
            if (ticks >= frequency) {
                player.playSound((Entity)other, "hbsmp:click", 1000.0f, 1.5f - (float)(distance / 50.0));
                ticks = 0;
            }
            pTicks.put(key, ticks);
            Vector direction = other.getEyeLocation().clone().subtract(eye).toVector().normalize();
            Location partLoc = eye.clone().add(direction.multiply(0.5));
            player.spawnParticle(Particle.DUST, partLoc, 1, (Object)new Particle.DustOptions(Color.fromRGB((int)755550), 0.1f));
        }
    }

    @Override
    public String getDescription() {
        return "Plays a ticking sound when players come within 50 blocks, the ticking noise grows more rapid as the player approaches. There is a particle indicating the direction of the player.";
    }
}

