/*
 * Decompiled with CFR 0.152.
 */
package com.alignedcookie88.heartbound_smp.buffs;

import com.alignedcookie88.heartbound_smp.util.TextUtil;
import java.util.List;
import org.bukkit.entity.Player;

public interface SlotQualifier {
    public boolean slotQualifies(int var1, Player var2);

    public String name();

    public static SlotQualifier combine(SlotQualifier qualifier) {
        return qualifier;
    }

    public static SlotQualifier combine(SlotQualifier ... qualifiers) {
        return SlotQualifier.combine(TextUtil.joinWithFinalDelimiter(List.of(qualifiers).stream().map(q -> q.name()).toList(), ", ", " or "), qualifiers);
    }

    public static SlotQualifier combine(final String name, final SlotQualifier qualifier) {
        return new SlotQualifier(){

            @Override
            public boolean slotQualifies(int id, Player player) {
                return qualifier.slotQualifies(id, player);
            }

            @Override
            public String name() {
                return name;
            }
        };
    }

    public static SlotQualifier combine(final String name, final SlotQualifier ... qualifiers) {
        return new SlotQualifier(){

            @Override
            public boolean slotQualifies(int id, Player player) {
                for (SlotQualifier qualifier : qualifiers) {
                    if (!qualifier.slotQualifies(id, player)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String name() {
                return name;
            }
        };
    }

    public static SlotQualifier slotMatches(final int matchId, final String name) {
        return new SlotQualifier(){

            @Override
            public boolean slotQualifies(int id, Player player) {
                return id == matchId;
            }

            @Override
            public String name() {
                return name;
            }
        };
    }
}

