/*
 * Decompiled with CFR 0.152.
 */
package com.alignedcookie88.heartbound_smp.buffs;

import com.alignedcookie88.heartbound_smp.CustomItem;
import com.alignedcookie88.heartbound_smp.buffs.BuffInstance;
import com.alignedcookie88.heartbound_smp.buffs.type.BuffType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class BuffManager {
    private static final Map<UUID, List<BuffType>> activeBuffs = new HashMap<UUID, List<BuffType>>();

    public static void tick(Player player) {
        List<BuffType> discovered = BuffManager.discoverBuffs(player);
        List active = activeBuffs.getOrDefault(player.getUniqueId(), List.of());
        for (BuffType type : discovered) {
            if (active.contains(type)) continue;
            type.enable(player);
        }
        for (BuffType type : active) {
            if (discovered.contains(type)) continue;
            type.disable(player);
        }
        activeBuffs.put(player.getUniqueId(), discovered);
        for (BuffType type : discovered) {
            type.tick(player);
        }
    }

    private static List<BuffType> discoverBuffs(Player player) {
        ArrayList<BuffType> discovered = new ArrayList<BuffType>();
        for (int slot = 0; slot <= 40; ++slot) {
            CustomItem customItem;
            ItemStack stack = player.getInventory().getItem(slot);
            if (stack == null || (customItem = CustomItem.fromStack(stack)) == null) continue;
            for (BuffInstance instance : customItem.buffs()) {
                if (!instance.applies(slot, player)) continue;
                discovered.add(instance.type());
            }
        }
        return discovered;
    }
}

