/*
 * Decompiled with CFR 0.152.
 */
package com.alignedcookie88.heartbound_smp.abilities;

import com.alignedcookie88.heartbound_smp.abilities.Ability;
import com.alignedcookie88.heartbound_smp.util.ParticleUtil;
import com.alignedcookie88.heartbound_smp.util.TrustUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;

public class GustAbility
extends Ability {
    private final Map<UUID, List<UUID>> immuneEntities = new HashMap<UUID, List<UUID>>();
    private Location location;

    public GustAbility() {
        super("<#6de880>Gust");
    }

    @Override
    protected void onActivate(Player player) {
        this.setCooldown(player, 600);
        this.deactivateAfter(player, 30);
        this.location = player.getLocation();
    }

    @Override
    protected void onDeactivate(Player player) {
        this.immuneEntities.remove(player.getUniqueId());
    }

    @Override
    protected void onTick(Player player) {
        int ticks = this.getActiveTicks(player);
        float radius = (float)ticks / 2.0f;
        ParticleUtil.particleCircle(this.location, radius, Particle.SMALL_GUST, null);
        List immune = this.immuneEntities.getOrDefault(player.getUniqueId(), new ArrayList());
        for (LivingEntity entity : this.location.getWorld().getLivingEntities()) {
            double distance = entity.getLocation().distance(this.location);
            if (!(distance <= (double)radius) || entity.getEntityId() == player.getEntityId() || TrustUtil.playerTrusts(player, (Entity)entity) || immune.contains(entity.getUniqueId())) continue;
            Vector direction = entity.getLocation().toVector().subtract(this.location.toVector()).setY(0).normalize();
            Vector velocity = direction.clone().setY(0.25).multiply(4);
            entity.setVelocity(entity.getVelocity().add(velocity));
            immune.add(entity.getUniqueId());
        }
        this.immuneEntities.put(player.getUniqueId(), immune);
    }

    @Override
    @Nullable
    protected String getDescription() {
        return "(Quite literally) blows away all the mobs and entities around you.";
    }

    @Override
    protected int getTypicalDuration() {
        return 30;
    }

    @Override
    protected int getTypicalCooldown() {
        return 600;
    }
}

