/*
 * Decompiled with CFR 0.152.
 */
package com.alignedcookie88.heartbound_smp.abilities;

import com.alignedcookie88.heartbound_smp.abilities.Ability;
import com.alignedcookie88.heartbound_smp.util.ParticleUtil;
import com.alignedcookie88.heartbound_smp.util.TrustUtil;
import org.bukkit.Color;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.Nullable;

public class DeathlyForcefieldAbility
extends Ability {
    public DeathlyForcefieldAbility() {
        super("<#162836>Deathly Forcefield");
    }

    @Override
    protected void onActivate(Player player) {
        this.setCooldown(player, 1200);
        this.deactivateAfter(player, 300);
    }

    @Override
    protected void onDeactivate(Player player) {
    }

    @Override
    protected void onTick(Player player) {
        if (player.isDead()) {
            return;
        }
        int cappedTicks = Math.min(this.getActiveTicks(player), 20);
        float radius = (float)cappedTicks / 4.0f;
        ParticleUtil.particleCircle(player.getLocation(), radius, Particle.DUST, new Particle.DustOptions(Color.fromRGB((int)1452086), 1.0f));
        for (LivingEntity entity : player.getWorld().getLivingEntities()) {
            double distance = entity.getLocation().distance(player.getLocation());
            if (!(distance <= (double)radius) || entity.getEntityId() == player.getEntityId() || TrustUtil.playerTrusts(player, (Entity)entity)) continue;
            entity.addPotionEffect(new PotionEffect(PotionEffectType.WITHER, 50, 3, true, true, true));
        }
    }

    @Override
    @Nullable
    protected String getDescription() {
        return "Creates a forcefield around yourself that applies the wither effect to all mobs and players around you.";
    }

    @Override
    protected int getTypicalDuration() {
        return 300;
    }

    @Override
    protected int getTypicalCooldown() {
        return 1200;
    }
}

