/*
 * Decompiled with CFR 0.152.
 */
package com.alignedcookie88.heartbound_smp.abilities;

import com.alignedcookie88.heartbound_smp.HeartboundSMP;
import com.alignedcookie88.heartbound_smp.lore.LoreBuilder;
import com.alignedcookie88.heartbound_smp.lore.LoreSection;
import java.util.HashMap;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public abstract class Ability {
    private final HashMap<UUID, Integer> cooldownEnds = new HashMap();
    private final HashMap<UUID, Integer> deactivateTimes = new HashMap();
    private final HashMap<UUID, Boolean> isActive = new HashMap();
    private final HashMap<UUID, Integer> activeSince = new HashMap();
    public final Component name;

    public Ability(String name) {
        this.name = MiniMessage.miniMessage().deserialize((Object)name);
        Bukkit.getScheduler().runTaskTimer((Plugin)HeartboundSMP.plugin, () -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!this.isActive(player)) continue;
                this.onTick(player);
            }
        }, 0L, 1L);
    }

    public int getCooldownEnd(Player player) {
        return this.cooldownEnds.getOrDefault(player.getUniqueId(), 0);
    }

    protected void setCooldownEnd(Player player, int cooldownEnd) {
        this.cooldownEnds.put(player.getUniqueId(), cooldownEnd);
    }

    protected void setCooldown(Player player, int cooldown) {
        this.setCooldownEnd(player, Bukkit.getCurrentTick() + cooldown);
    }

    public boolean isActive(Player player) {
        return this.isActive.getOrDefault(player.getUniqueId(), false);
    }

    protected void setActive(Player player, boolean active) {
        boolean previous = this.isActive(player);
        this.isActive.put(player.getUniqueId(), active);
        if (active && !previous) {
            this.activeSince.put(player.getUniqueId(), Bukkit.getCurrentTick());
            this.onActivate(player);
        } else if (!active && previous) {
            this.onDeactivate(player);
        }
    }

    protected void deactivateAfter(Player player, int time) {
        Bukkit.getScheduler().runTaskLater((Plugin)HeartboundSMP.plugin, () -> this.setActive(player, false), (long)time);
        this.deactivateTimes.put(player.getUniqueId(), Bukkit.getCurrentTick() + time);
    }

    public int getDeactivateTime(Player player) {
        return this.deactivateTimes.getOrDefault(player.getUniqueId(), 0);
    }

    protected int getActiveSince(Player player) {
        return this.activeSince.getOrDefault(player.getUniqueId(), Integer.MAX_VALUE);
    }

    protected int getActiveTicks(Player player) {
        return Math.max(0, Bukkit.getCurrentTick() - this.getActiveSince(player));
    }

    public boolean use(Player player) {
        if (this.isActive(player)) {
            return this.onUseWhenActive(player);
        }
        if (this.getCooldownEnd(player) < Bukkit.getCurrentTick()) {
            this.setActive(player, true);
            player.playSound(player.getLocation(), Sound.BLOCK_BEACON_ACTIVATE, 20.0f, 1.0f);
            String endMsg = " It will deactivate in <white>\u231b %s<gray>.".formatted(HeartboundSMP.formatCountdownEnd(this.getDeactivateTime(player)));
            if (!this.isActive(player)) {
                endMsg = "";
            }
            player.sendMessage(((TextComponent)((TextComponent)Component.empty().append(MiniMessage.miniMessage().deserialize((Object)"<#b03a89><bold>\u00bb </bold><gray>You activated "))).append(this.name)).append(MiniMessage.miniMessage().deserialize((Object)("<gray>!" + endMsg))));
            return true;
        }
        return false;
    }

    protected abstract void onActivate(Player var1);

    protected abstract void onDeactivate(Player var1);

    protected boolean onUseWhenActive(Player player) {
        return false;
    }

    protected void onTick(Player player) {
    }

    public void addLore(LoreBuilder builder) {
        LoreSection section = new LoreSection(((TextComponent)Component.empty().append((Component)Component.text((String)"Ability: "))).append(this.name));
        if (this.getDescription() != null) {
            section.withDescription(this.getDescription());
        }
        if (this.getTypicalDuration() > 0) {
            section.withPoint((Component)Component.text((String)"Duration"), (Component)Component.text((String)("\u231b " + HeartboundSMP.formatCountdown(this.getTypicalDuration()))));
        } else if (this.getTypicalDuration() == 0) {
            section.withPoint((Component)Component.text((String)"Duration"), (Component)Component.text((String)"Instant"));
        }
        if (this.getTypicalCooldown() >= 0) {
            section.withPoint((Component)Component.text((String)"Cooldown"), (Component)Component.text((String)("\u231b " + HeartboundSMP.formatCountdown(this.getTypicalCooldown()))));
        }
        section.withPoint((Component)Component.text((String)"Keybind"), (Component)Component.keybind((String)"key.swapOffhand"));
        builder.withSection(section);
    }

    @Nullable
    protected String getDescription() {
        return null;
    }

    protected int getTypicalDuration() {
        return -1;
    }

    protected int getTypicalCooldown() {
        return -1;
    }
}

