/*
 * Decompiled with CFR 0.152.
 */
package com.alignedcookie88.heartbound_smp;

import com.alignedcookie88.heartbound_smp.HeartboundSMP;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.file.Path;

public class SavedData {
    public static boolean hasDragonBeenKilled = false;

    private static Path getSaveFile() {
        return HeartboundSMP.plugin.getDataPath().resolve("saved_data.json");
    }

    public static void load() {
        HeartboundSMP.plugin.getLogger().info("Loading data");
        File saveFile = SavedData.getSaveFile().toFile();
        if (!saveFile.exists()) {
            HeartboundSMP.plugin.getLogger().info("No save file exists, skipping.");
            return;
        }
        try {
            FileInputStream stream = new FileInputStream(saveFile);
            InputStreamReader reader = new InputStreamReader(stream);
            JsonElement json = JsonParser.parseReader((Reader)reader);
            reader.close();
            ((InputStream)stream).close();
            SavedData.loadJson(json);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private static void loadJson(JsonElement element) {
        JsonObject obj = (JsonObject)element;
        hasDragonBeenKilled = obj.getAsJsonPrimitive("hasDragonBeenKilled").getAsBoolean();
    }

    public static void save() {
        HeartboundSMP.plugin.getLogger().info("Saving data");
        try {
            File saveFile = SavedData.getSaveFile().toFile();
            if (!saveFile.exists()) {
                SavedData.getSaveFile().getParent().toFile().mkdirs();
                saveFile.createNewFile();
            }
            FileOutputStream stream = new FileOutputStream(saveFile);
            OutputStreamWriter writer = new OutputStreamWriter(stream);
            new Gson().toJson(SavedData.saveJson(), (Appendable)writer);
            writer.flush();
            writer.close();
            ((OutputStream)stream).close();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private static JsonElement saveJson() {
        JsonObject obj = new JsonObject();
        obj.add("__README", (JsonElement)new JsonPrimitive("DO NOT EDIT THIS FILE MANUALLY! It may cause the plugin to not load, or even cause undefined behaviour."));
        obj.add("hasDragonBeenKilled", (JsonElement)new JsonPrimitive(Boolean.valueOf(hasDragonBeenKilled)));
        return obj;
    }
}

