/*
 * Decompiled with CFR 0.152.
 */
package com.alignedcookie88.heartbound_smp;

import com.alignedcookie88.heartbound_smp.CustomItem;
import com.alignedcookie88.heartbound_smp.DatapackLoader;
import com.alignedcookie88.heartbound_smp.Infusion;
import com.alignedcookie88.heartbound_smp.SavedData;
import com.alignedcookie88.heartbound_smp.abilities.Ability;
import com.alignedcookie88.heartbound_smp.abilities.DeathlyForcefieldAbility;
import com.alignedcookie88.heartbound_smp.abilities.FlightAbility;
import com.alignedcookie88.heartbound_smp.abilities.GustAbility;
import com.alignedcookie88.heartbound_smp.abilities.PowerTripAbility;
import com.alignedcookie88.heartbound_smp.abilities.SonicBoomAbility;
import com.alignedcookie88.heartbound_smp.buffs.BuffManager;
import com.alignedcookie88.heartbound_smp.buffs.SlotQualifiers;
import com.alignedcookie88.heartbound_smp.buffs.type.BuffTypes;
import com.alignedcookie88.heartbound_smp.crafting.CraftingManager;
import com.alignedcookie88.heartbound_smp.lore.LoreBadge;
import com.alignedcookie88.heartbound_smp.pedestal.AmethystPedestalManager;
import com.alignedcookie88.heartbound_smp.pedestal.PedestalRecipe;
import com.alignedcookie88.heartbound_smp.util.AdvancementUtil;
import com.alignedcookie88.heartbound_smp.util.InfusionUtil;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.nikey.combatLog.Listener.GeneralListener;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.entity.PlayerGiveResult;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.time.Duration;
import java.util.ArrayList;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.title.Title;
import net.kyori.adventure.title.TitlePart;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MainHand;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class HeartboundSMP
extends JavaPlugin
implements Listener {
    public static final String UNIQUE_BADGE = "<white><font:hbsmp:symbols>e</font> </white>";
    public static final String DOUBLE_ARROW = "\u00bb";
    public static final String TRIPLE_ARROW = "<font:hbsmp:symbols>c</font>";
    public static final String QUAD_ARROW = "<font:hbsmp:symbols>d</font>";
    public static final String LIGHT_COLOUR = "#a87c9a";
    public static final String MESSAGE_PREFIX = "<#b03a89><bold>\u00bb </bold>";
    public static final String SECONDARY_COLOUR = "#6a2252";
    public static final String LOGO_TEXT = "<shadow:#00000000><white><font:hbsmp:symbols>a</font></white></shadow>";
    public static HeartboundSMP plugin;
    public static CustomItem DRAGON_HEART;
    public static CustomItem TOTEM_OF_ASCENT;
    public static CustomItem WITHER_HEART;
    public static CustomItem TOTEM_OF_WITHERING;
    public static CustomItem ELDER_GUARDIAN_HEART;
    public static CustomItem TOTEM_OF_SUBMERSION;
    public static CustomItem WARDEN_HEART;
    public static CustomItem TOTEM_OF_RESONANCE;
    public static CustomItem BREEZE_HEART;
    public static CustomItem TOTEM_OF_WAFTING;
    public static CustomItem MEGATOTEM;
    public static CustomItem PRISM_OF_REAPING;
    public static CustomItem OVERENCHANTING_CRYSTAL;

    public void onEnable() {
        plugin = this;
        SavedData.load();
        DatapackLoader.loadDatapack();
        DRAGON_HEART = new CustomItem("dragon_heart", "<white><font:hbsmp:symbols>e</font> </white><gradient:#5e1669:#290a2e>Dragon Heart", "hbsmp:dragon_heart").withAdvancement("hbsmp:hearthunting").withLore(lore -> lore.withBadge(LoreBadge.UNIQUE).withDescription("Whilst useless on its own, the Dragon Heart is used to craft the Totem of Ascent."));
        TOTEM_OF_ASCENT = new CustomItem("totem_of_ascent", "<white><font:hbsmp:symbols>e</font> </white><gradient:#5e1669:#290a2e>Totem of Ascent", "hbsmp:totem_of_ascent").withAdvancement("hbsmp:totem/fly_into_the_wind").withAbility(new FlightAbility()).withLore(lore -> lore.withBadge(LoreBadge.UNIQUE).withDescription("The ultimate escape and travel totem."));
        WITHER_HEART = new CustomItem("wither_heart", "<#8abdd4>Wither Heart", "hbsmp:wither_heart").withAdvancement("hbsmp:hearthunting");
        TOTEM_OF_WITHERING = new CustomItem("totem_of_withering", "<#8abdd4>Totem of Withering", "hbsmp:totem_of_withering").withAdvancement("hbsmp:totem/slightly_frightening").withAbility(new DeathlyForcefieldAbility());
        ELDER_GUARDIAN_HEART = new CustomItem("elder_guardian_heart", "<#5755ab>Elder Guardian Heart", "hbsmp:elder_guardian_heart").withAdvancement("hbsmp:hearthunting");
        TOTEM_OF_SUBMERSION = new CustomItem("totem_of_submersion", "<#5755ab>Totem of Submersion", "hbsmp:totem_of_submersion").withAdvancement("hbsmp:totem/underwater_euphoria").withBuff(BuffTypes.AMPHIBIAN, SlotQualifiers.EITHER_HAND);
        WARDEN_HEART = new CustomItem("warden_heart", "<#4f4fe8>Warden Heart", "hbsmp:warden_heart").withAdvancement("hbsmp:hearthunting");
        TOTEM_OF_RESONANCE = new CustomItem("totem_of_resonance", "<#4f4fe8>Totem of Resonance", "hbsmp:totem_of_resonance").withAdvancement("hbsmp:totem/careful_listening").withBuff(BuffTypes.EAVESDROPPING, SlotQualifiers.EITHER_HAND).withAbility(new SonicBoomAbility());
        BREEZE_HEART = new CustomItem("breeze_heart", "<#d09ef0>Breeze Heart", "hbsmp:breeze_heart").withAdvancement("hbsmp:hearthunting");
        TOTEM_OF_WAFTING = new CustomItem("totem_of_wafting", "<#d09ef0>Totem of Wafting", "hbsmp:totem_of_wafting").withAdvancement("hbsmp:totem/a_slight_breeze").withAbility(new GustAbility());
        MEGATOTEM = new CustomItem("megatotem", "<white><font:hbsmp:symbols>e</font> </white><bold><gradient:#ffcd17:#ffe68a>MEGATOTEM", "hbsmp:megatotem").withAdvancement("hbsmp:the_unstoppable_power").withBuff(BuffTypes.FLIGHT, SlotQualifiers.EITHER_HAND).withBuff(BuffTypes.HEALTH_BOOST, SlotQualifiers.EITHER_HAND).withBuff(BuffTypes.CRAB, SlotQualifiers.EITHER_HAND).withBuff(BuffTypes.REACH, SlotQualifiers.EITHER_HAND).withBuff(BuffTypes.AMPHIBIAN, SlotQualifiers.EITHER_HAND).withAbility(new PowerTripAbility()).withLore(lore -> lore.withBadge(LoreBadge.UNIQUE));
        PRISM_OF_REAPING = new CustomItem("prism_of_reaping", "<white><font:hbsmp:symbols>e</font> </white><gradient:#7734eb:#eb4034>Prism Of Reaping", "hbsmp:prism_of_reaping").withLore(lore -> lore.withDescription("Use electric fusion to fuse this prism into an item to infuse it with reaping. When an item infused with reaping is used to kill a player, the killer receives one of the victim's hearts. If a player runs out of hearts they are permanently banned for the rest of the season.").withBadge(LoreBadge.UNIQUE));
        OVERENCHANTING_CRYSTAL = new CustomItem("overenchanting_crystal", "<gradient:#b4c748:#ced69f>Over-enchanting Crystal", "hbsmp:overenchanting_crystal").withLore(lore -> lore.withDescription("Combine an over-enchanting crystal, an enchanting book and any other item via electric fusion to enchant the item with the book, with an extra level on the enchantment. It uses the lowest level enchantment on the book, if there are multiple enchantments at this level it picks one at random."));
        this.getLifecycleManager().registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, commands -> {
            ((Commands)commands.registrar()).register(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"get_item").requires(commandSourceStack -> commandSourceStack.getSender().hasPermission("hbsmp.get_item"))).then(Commands.argument((String)"id", (ArgumentType)StringArgumentType.word()).suggests((commandContext, suggestionsBuilder) -> {
                for (String id : CustomItem.ids()) {
                    suggestionsBuilder.suggest(id);
                }
                return suggestionsBuilder.buildFuture();
            }).executes(context -> {
                String id = StringArgumentType.getString((CommandContext)context, (String)"id");
                CustomItem item = CustomItem.fromId(id);
                if (item == null) {
                    ((CommandSourceStack)context.getSource()).getSender().sendMessage("Invalid ID");
                    return 0;
                }
                Entity patt0$temp = ((CommandSourceStack)context.getSource()).getExecutor();
                if (patt0$temp instanceof Player) {
                    Player player = (Player)patt0$temp;
                    player.give(new ItemStack[]{item.getStack()});
                }
                return 0;
            }))).build());
            ((Commands)commands.registrar()).register(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"reset_dragon_kill_flag").requires(commandSourceStack -> commandSourceStack.getSender().hasPermission("hbsmp.reset_dragon_kill_flag"))).executes(context -> {
                SavedData.hasDragonBeenKilled = false;
                return 0;
            })).build());
            ((Commands)commands.registrar()).register(((LiteralArgumentBuilder)Commands.literal((String)"join_heartbound").executes(context -> {
                ((CommandSourceStack)context.getSource()).getSender().sendMessage(MiniMessage.miniMessage().deserialize((Object)"<click:open_url:\"https://alignedcookie88.com/join_heartbound?utm_source=public_plugin&utm_campaign=season1_public\"><hover:show_text:\"<font:hbsmp:symbols>b</font> Click to open the invite link!\"><#b03a89><bold>\u00bb </bold><grey>Click this message to join the <bold>official</bold> Heartbound SMP <white><font:hbsmp:symbols>b</font></white> discord server."));
                return 0;
            })).build());
        });
        Infusion.setupInfusions();
        CraftingManager.setupRecipes();
        PedestalRecipe.setupRecipes();
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        Bukkit.getScheduler().runTaskTimer((Plugin)this, () -> {
            for (Player player : Bukkit.getServer().getOnlinePlayers()) {
                HeartboundSMP.tickPlayer(player);
            }
        }, 0L, 1L);
    }

    public void onDisable() {
        SavedData.save();
    }

    private static Component getActionBarInfo(Player player, ItemStack stack, CustomItem item, boolean shiftRequired) {
        if (item.ability() != null) {
            Ability ability = item.ability();
            String key = shiftRequired ? "<key:key.sneak> + <key:key.swapOffhand>" : "<key:key.swapOffhand>";
            String ending = "<reset><bold> </bold><gray>[" + key + "]";
            if (ability.isActive(player)) {
                return MiniMessage.miniMessage().deserialize((Object)("<#8fff40><bold>ACTIVE </bold><white>\u231b " + HeartboundSMP.formatCountdownEnd(ability.getDeactivateTime(player)) + ending));
            }
            int cooldownEnd = ability.getCooldownEnd(player);
            if (cooldownEnd > Bukkit.getCurrentTick()) {
                return MiniMessage.miniMessage().deserialize((Object)("<#ffdf40><bold>COOLDOWN </bold><white>\u231b " + HeartboundSMP.formatCountdownEnd(cooldownEnd)));
            }
            return MiniMessage.miniMessage().deserialize((Object)("<#40ffa9><bold>\u2714 READY" + ending));
        }
        return Component.empty();
    }

    private static boolean showsInfo(CustomItem item) {
        return item.ability() != null;
    }

    public static void tickPlayer(Player player) {
        int combatTimer;
        ItemStack offhand = player.getInventory().getItemInOffHand();
        CustomItem cOffhand = CustomItem.fromStack(offhand);
        ItemStack mainhand = player.getInventory().getItemInMainHand();
        CustomItem cMainhand = CustomItem.fromStack(mainhand);
        ArrayList<Component> actionBar = new ArrayList<Component>();
        if (cOffhand != null && HeartboundSMP.showsInfo(cOffhand) && cMainhand != null && HeartboundSMP.showsInfo(cMainhand)) {
            boolean leftHanded;
            Component tOffhand = HeartboundSMP.getActionBarInfo(player, offhand, cOffhand, false);
            Component tMainhand = HeartboundSMP.getActionBarInfo(player, mainhand, cMainhand, true);
            boolean bl = leftHanded = player.getMainHand() == MainHand.LEFT;
            if (leftHanded) {
                actionBar.add(tMainhand);
                actionBar.add(tOffhand);
            } else {
                actionBar.add(tOffhand);
                actionBar.add(tMainhand);
            }
        } else if (cOffhand != null && HeartboundSMP.showsInfo(cOffhand)) {
            actionBar.add(HeartboundSMP.getActionBarInfo(player, offhand, cOffhand, false));
        } else if (cMainhand != null && HeartboundSMP.showsInfo(cMainhand)) {
            actionBar.add(HeartboundSMP.getActionBarInfo(player, mainhand, cMainhand, false));
        }
        if (Bukkit.getPluginManager().isPluginEnabled("CombatLog") && (combatTimer = GeneralListener.combatTimers.getOrDefault(player.getUniqueId(), 0).intValue()) > 0) {
            actionBar.add(MiniMessage.miniMessage().deserialize((Object)("<#FF0055><bold>IN COMBAT! </bold><white>\u231b " + HeartboundSMP.formatCountdown(combatTimer * 20))));
        }
        if (actionBar.isEmpty()) {
            player.sendActionBar((Component)Component.empty());
        } else if (actionBar.size() == 1) {
            player.sendActionBar((Component)actionBar.getFirst());
        } else {
            Component separator = MiniMessage.miniMessage().deserialize((Object)"<gray>  ||  ");
            TextComponent component = Component.empty();
            for (int i = 0; i < actionBar.size(); ++i) {
                component = component.append((Component)actionBar.get(i));
                if (i >= actionBar.size() - 1) continue;
                component = component.append(separator);
            }
            player.sendActionBar((Component)component);
        }
        BuffManager.tick(player);
        AdvancementUtil.grantForAllItems(player);
    }

    public static String formatCountdownEnd(int ticks) {
        return HeartboundSMP.formatCountdown(ticks - Bukkit.getCurrentTick());
    }

    public static String formatCountdown(int ticks) {
        if (ticks <= 0) {
            return "0s";
        }
        int seconds = ticks / 20;
        if (seconds <= 60) {
            return seconds + "s";
        }
        return "%02.0f:%02.0f".formatted(Float.valueOf(seconds / 60), Float.valueOf(seconds % 60));
    }

    @EventHandler
    public void onSwapHands(PlayerSwapHandItemsEvent event) {
        ItemStack offhand = event.getOffHandItem();
        CustomItem cOffhand = CustomItem.fromStack(offhand);
        boolean vOffhand = cOffhand != null && cOffhand.ability() != null;
        ItemStack mainhand = event.getMainHandItem();
        CustomItem cMainhand = CustomItem.fromStack(mainhand);
        boolean vMainhand = cMainhand != null && cMainhand.ability() != null;
        Player player = event.getPlayer();
        if (!(!vMainhand || player.isSneaking() && vOffhand)) {
            event.setCancelled(true);
            if (cMainhand.ability().use(player)) {
                return;
            }
        }
        if (vOffhand) {
            event.setCancelled(true);
            cOffhand.ability().use(player);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (player.getGameMode() != GameMode.CREATIVE && player.getGameMode() != GameMode.SPECTATOR) {
            player.setAllowFlight(false);
            player.setFlying(false);
        }
        player.sendTitlePart(TitlePart.TIMES, (Object)Title.Times.times((Duration)Duration.ZERO, (Duration)Duration.ofSeconds(5L), (Duration)Duration.ofMillis(500L)));
        player.sendTitlePart(TitlePart.TITLE, (Object)MiniMessage.miniMessage().deserialize((Object)LOGO_TEXT));
        player.sendPlayerListHeaderAndFooter(MiniMessage.miniMessage().deserialize((Object)"<newline><gray>  This server uses the plugin  <newline>  from season 1 of the  <white><newline><newline><shadow:#00000000><white><font:hbsmp:symbols>a</font></white></shadow><newline><newline>"), MiniMessage.miniMessage().deserialize((Object)"<newline><gray>  Join the <bold>official</bold>  <newline>  Heartbound SMP discord  <newline>  server to get access  <newline>  to the plugin download and  <newline>  official SMP server.  <newline><white><font:hbsmp:symbols>b</font> /join_heartbound<newline>"));
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
            if (!player.isOnline()) {
                return;
            }
            player.sendMessage(MiniMessage.miniMessage().deserialize((Object)"<#b03a89><bold>\u00bb </bold><gray>This server uses the plugin from Heartbound SMP season 1. Join the <bold>official</bold> Heartbound SMP discord server to get access to plugin downloads and the official SMP server by running <white><font:hbsmp:symbols>b</font> /join_heartbound<gray>."));
        }, 20L);
        CustomItem.upgradeAllStacks((Inventory)player.getInventory());
        AttributeInstance maxHealth = player.getAttribute(Attribute.MAX_HEALTH);
        if (maxHealth.getBaseValue() <= 0.0) {
            player.kick((Component)Component.text((String)"You were reaped and lost your last heart!"));
        }
    }

    @EventHandler
    public void onPrepareItemCraft(PrepareItemCraftEvent event) {
        ItemStack result = CraftingManager.craft(event.getInventory(), null);
        if (result != null) {
            event.getInventory().setResult(result.clone());
        }
    }

    @EventHandler
    public void onCraftItem(CraftItemEvent event) {
        if (event.isCancelled()) {
            return;
        }
        HumanEntity crafter = event.getWhoClicked();
        Player player = crafter instanceof Player ? (Player)crafter : null;
        ItemStack noPlayerResult = CraftingManager.craft(event.getInventory(), null);
        ItemStack result = CraftingManager.craft(event.getInventory(), player);
        if (noPlayerResult != null && result == null) {
            event.setCancelled(true);
            if (player != null) {
                player.updateInventory();
            }
        }
        if (result != null) {
            event.setCurrentItem(result.clone());
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK && AmethystPedestalManager.isValidPedestal(event.getClickedBlock())) {
            AmethystPedestalManager.handleClick(event);
        }
    }

    @EventHandler
    public void onBlockPhysics(BlockPhysicsEvent event) {
        AmethystPedestalManager.updateBlock(event.getBlock(), event.getChangedType());
    }

    @EventHandler
    public void onDispenserUse(BlockDispenseEvent event) {
        Block dispenser = event.getBlock();
        if (dispenser.getType() != Material.DISPENSER) {
            return;
        }
        BlockData data = dispenser.getBlockData();
        if (!(data instanceof Directional)) {
            return;
        }
        Directional directional = (Directional)data;
        BlockFace facing = directional.getFacing();
        Block target = dispenser.getRelative(facing);
        if (AmethystPedestalManager.isValidPedestal(target)) {
            ItemStack dispensed = event.getItem();
            event.setCancelled(true);
            if (AmethystPedestalManager.isEmpty(target.getLocation())) {
                ItemStack pedestalItem = dispensed.clone();
                pedestalItem.setAmount(1);
                AmethystPedestalManager.setStack(target.getLocation(), pedestalItem);
                Bukkit.getScheduler().runTaskLater((Plugin)plugin, () -> {
                    BlockState state = dispenser.getState();
                    if (!(state instanceof Container)) {
                        return;
                    }
                    Container container = (Container)state;
                    Inventory inv = container.getInventory();
                    for (int i = 0; i < inv.getSize(); ++i) {
                        ItemStack slotItem = inv.getItem(i);
                        if (slotItem == null || !slotItem.isSimilar(dispensed)) continue;
                        if (slotItem.getAmount() <= 1) {
                            inv.clear(i);
                            break;
                        }
                        slotItem.setAmount(slotItem.getAmount() - 1);
                        inv.setItem(i, slotItem);
                        break;
                    }
                }, 1L);
            }
        }
    }

    @EventHandler
    public void onEntityDeath(EntityDeathEvent event) {
        LivingEntity entity = event.getEntity();
        Player killer = entity.getKiller();
        EntityType type = entity.getType();
        if (killer != null) {
            ItemStack weapon;
            CustomItem heart;
            if (type == EntityType.ENDER_DRAGON && !SavedData.hasDragonBeenKilled) {
                SavedData.hasDragonBeenKilled = true;
                SavedData.save();
                this.giveHeart(killer, DRAGON_HEART);
            }
            switch (type) {
                case WITHER: {
                    CustomItem customItem = WITHER_HEART;
                    break;
                }
                case ELDER_GUARDIAN: {
                    CustomItem customItem = ELDER_GUARDIAN_HEART;
                    break;
                }
                case WARDEN: {
                    CustomItem customItem = WARDEN_HEART;
                    break;
                }
                case BREEZE: {
                    CustomItem customItem = BREEZE_HEART;
                    break;
                }
                default: {
                    CustomItem customItem = heart = null;
                }
            }
            if (heart != null) {
                this.giveHeart(killer, heart);
            }
            if ((weapon = killer.getInventory().getItemInMainHand()).isEmpty()) {
                weapon = killer.getInventory().getItemInOffHand();
            }
            if (entity instanceof Player) {
                Player victim = (Player)entity;
                if (!weapon.isEmpty() && InfusionUtil.hasInfusion(weapon, Infusion.REAPING)) {
                    AttributeInstance victimAttr = victim.getAttribute(Attribute.MAX_HEALTH);
                    victimAttr.setBaseValue(victimAttr.getBaseValue() - 2.0);
                    AttributeInstance killerAttr = killer.getAttribute(Attribute.MAX_HEALTH);
                    killerAttr.setBaseValue(killerAttr.getBaseValue() + 2.0);
                    if (victimAttr.getBaseValue() <= 0.0) {
                        victim.kick((Component)Component.text((String)"You were reaped and lost your last heart!"));
                        this.getServer().sendMessage(MiniMessage.miniMessage().deserialize((Object)("<#b03a89><bold>\u00bb </bold><gray>" + victim.getName() + " was reaped by " + killer.getName() + " and lost their last heart! They are now permanently dead for the rest of this season.")));
                    } else {
                        this.getServer().sendMessage(MiniMessage.miniMessage().deserialize((Object)("<#b03a89><bold>\u00bb </bold><gray>" + victim.getName() + " was reaped by " + killer.getName() + "!")));
                    }
                }
            }
        }
    }

    public void giveHeart(Player player, CustomItem item) {
        PlayerGiveResult result = player.give(new ItemStack[]{item.getStack()});
        if (!result.leftovers().isEmpty()) {
            player.getInventory().setItemInMainHand(item.getStack());
            player.sendMessage(MiniMessage.miniMessage().deserialize((Object)"<#b03a89><bold>\u00bb </bold><gray>The item in your main hand was replaced because your inventory was full!"));
        }
    }
}

