/*
 * Decompiled with CFR 0.152.
 */
package com.alignedcookie88.heartbound_smp;

import com.alignedcookie88.heartbound_smp.HeartboundSMP;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class DatapackLoader {
    public static void loadDatapack() {
        Logger logger = HeartboundSMP.plugin.getLogger();
        logger.info("Finding datapack folder");
        File worldFolder = ((World)Bukkit.getWorlds().get(0)).getWorldFolder();
        File datapackFolder = new File(worldFolder, "datapacks/heartbound_smp");
        try {
            logger.info("Deleting existing datapack");
            DatapackLoader.deleteFolderRecursively(datapackFolder.toPath());
            logger.info("Copying new datapack");
            DatapackLoader.extractFolderFromJar("datapack", datapackFolder);
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
        logger.info("Scheduling datapack enable");
        Bukkit.getScheduler().runTaskLater((Plugin)HeartboundSMP.plugin, () -> {
            logger.info("Enabling datapack");
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)"datapack disable \"file/heartbound_smp\"");
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)"datapack enable \"file/heartbound_smp\"");
        }, 20L);
    }

    public static void extractFolderFromJar(String resourceFolder, File destination) throws IOException, URISyntaxException {
        if (!destination.exists()) {
            destination.mkdirs();
        }
        try (JarFile jar = new JarFile(new File(DatapackLoader.class.getProtectionDomain().getCodeSource().getLocation().toURI()));){
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith(resourceFolder)) continue;
                String relativePath = name.substring(resourceFolder.length() + 1);
                File outFile = new File(destination, relativePath);
                if (entry.isDirectory()) {
                    outFile.mkdirs();
                    continue;
                }
                InputStream in = DatapackLoader.class.getResourceAsStream("/" + name);
                try (FileOutputStream out = new FileOutputStream(outFile);){
                    int len;
                    byte[] buffer = new byte[4096];
                    while ((len = in.read(buffer)) > 0) {
                        ((OutputStream)out).write(buffer, 0, len);
                    }
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
        }
    }

    public static void deleteFolderRecursively(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

