/*
 * Decompiled with CFR 0.152.
 */
package com.alignedcookie88.heartbound_smp;

import com.alignedcookie88.heartbound_smp.HeartboundSMP;
import com.alignedcookie88.heartbound_smp.abilities.Ability;
import com.alignedcookie88.heartbound_smp.buffs.BuffInstance;
import com.alignedcookie88.heartbound_smp.buffs.SlotQualifier;
import com.alignedcookie88.heartbound_smp.buffs.type.BuffType;
import com.alignedcookie88.heartbound_smp.lore.LoreBuilder;
import io.papermc.paper.persistence.PersistentDataContainerView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class CustomItem {
    private static final NamespacedKey ID_KEY = NamespacedKey.fromString((String)"custom_item_id", (Plugin)HeartboundSMP.plugin);
    private static final HashMap<String, CustomItem> itemHashMap = new HashMap();
    public final String id;
    public final Component name;
    public final String model;
    private Ability ability = null;
    private final List<BuffInstance> buffs = new ArrayList<BuffInstance>();
    private final List<String> advancements = new ArrayList<String>();
    private final ItemStack stack;
    private final LoreBuilder lore;

    public static CustomItem fromId(String id) {
        return itemHashMap.get(id);
    }

    public static CustomItem fromStack(ItemStack stack) {
        PersistentDataContainerView pdc = stack.getPersistentDataContainer();
        String id = (String)pdc.get(ID_KEY, PersistentDataType.STRING);
        if (id == null) {
            return null;
        }
        return CustomItem.fromId(id);
    }

    public static Set<String> ids() {
        return itemHashMap.keySet();
    }

    public static ItemStack upgradeStack(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        ItemMeta meta = stack.getItemMeta();
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        CustomItem customItem = CustomItem.fromStack(stack);
        if (customItem == null) {
            return stack;
        }
        ItemStack newStack = customItem.getStack();
        newStack.setAmount(stack.getAmount());
        ItemMeta newMeta = newStack.getItemMeta();
        for (Map.Entry entry : meta.getEnchants().entrySet()) {
            newMeta.addEnchant((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue(), true);
        }
        newMeta.customName(meta.customName());
        PersistentDataContainer newPdc = newMeta.getPersistentDataContainer();
        pdc.copyTo(newPdc, true);
        newStack.setItemMeta(newMeta);
        return newStack;
    }

    public static void upgradeAllStacks(Inventory inventory) {
        for (int slot = 0; slot < inventory.getSize(); ++slot) {
            ItemStack upgraded;
            ItemStack stack = inventory.getItem(slot);
            if (stack == (upgraded = CustomItem.upgradeStack(stack))) continue;
            inventory.setItem(slot, upgraded);
        }
    }

    public CustomItem(String id, String name, String model) {
        this.id = id;
        this.name = MiniMessage.miniMessage().deserialize((Object)("<!italic>" + name));
        this.model = model;
        this.stack = new ItemStack(Material.PAPER, 1);
        this.stack.editMeta(meta -> {
            meta.setItemModel(NamespacedKey.fromString((String)model));
            meta.itemName(this.name);
            PersistentDataContainer pdc = meta.getPersistentDataContainer();
            pdc.set(ID_KEY, PersistentDataType.STRING, (Object)id);
        });
        this.lore = LoreBuilder.create();
        itemHashMap.put(id, this);
    }

    public CustomItem withAbility(Ability ability) {
        this.ability = ability;
        this.withLore(ability::addLore);
        return this;
    }

    public CustomItem withBuff(BuffInstance buff) {
        this.buffs.add(buff);
        this.withLore(buff::addLore);
        return this;
    }

    public CustomItem withBuff(BuffType buff, SlotQualifier slot) {
        return this.withBuff(new BuffInstance(buff, slot));
    }

    public CustomItem withLore(Consumer<LoreBuilder> consumer) {
        consumer.accept(this.lore);
        this.stack.editMeta(meta -> meta.lore(this.lore.build()));
        return this;
    }

    public CustomItem withAdvancement(String key) {
        this.advancements.add(key);
        return this;
    }

    public ItemStack getStack() {
        return this.stack.clone();
    }

    public Ability ability() {
        return this.ability;
    }

    public List<BuffInstance> buffs() {
        return List.copyOf(this.buffs);
    }

    public List<String> advancements() {
        return List.copyOf(this.advancements);
    }
}

